<?php

//////////////////////////////////////////////////////////////////
// Customizer - Add Custom Styling
//////////////////////////////////////////////////////////////////
function vinethemes_customizer_style()
{
    wp_enqueue_style('customizer-css', get_stylesheet_directory_uri() . '/functions/customizer/css/customizer.css');
}
add_action('customize_controls_print_styles', 'vinethemes_customizer_style');

//////////////////////////////////////////////////////////////////
// Customizer - Add Settings
//////////////////////////////////////////////////////////////////
function vinethemes_register_theme_customizer( $wp_customize ) {

    // Add Sections




    $wp_customize->add_section( 'vinethemes_new_section_footer' , array(
        'title'      => 'Footer Settings',
        'description'=> 'You cannot remove Footer Links, purchase the <a href="http://www.vinethemes.com/downloads/devout-personal-wordpress-theme/">Premium Version</a> of this theme to do so.',
        'priority'   => 99,
    ) );

    $wp_customize->add_section( 'vinethemes_new_section_social' , array(
        'title'      => 'Social Media Settings',
        'description'=> 'Enter your social media usernames. Icons will not show if left blank. <br/><br/>Only 3 social media are available in Free Version, <a href="http://www.vinethemes.com/downloads/devout-personal-wordpress-theme/">Purchase the Theme</a> for Premium Features',
        'priority'   => 98,
    ) );

    $wp_customize->add_section( 'vinethemes_new_section_page' , array(
        'title'      => 'Page Settings',
        'description'=> '',
        'priority'   => 97,
    ) );

    $wp_customize->add_section( 'vinethemes_new_section_post' , array(
        'title'      => 'Post Settings',
        'description'=> '',
        'priority'   => 96,
    ) );

    $wp_customize->add_section( 'vinethemes_new_section_featured' , array(
        'title'      => 'Slider Area Settings',
        'description'=> '(Carousel is not available in the Free Version. Buy <a href="http://www.vinethemes.com/downloads/devout-personal-wordpress-theme/">Premium Version</a>)',
        'priority'   => 94,
    ) );

    $wp_customize->add_section( 'vinethemes_new_section_featured_boxes' , array(
        'title'      => 'Featured Boxes Area Settings',
        'description'=> '',
        'priority'   => 95,
    ) );

    $wp_customize->add_section( 'vinethemes_new_section_topbar' , array(
        'title'      => 'Top Bar Settings',
        'description'=> '',
        'priority'   => 92,
    ) );



    $wp_customize->add_section( 'vinethemes_new_section_logo_header' , array(
        'title'      => 'Logo and Header Settings',
        'description'=> '',
        'priority'   => 91,
    ) );

    $wp_customize->add_section( 'vinethemes_new_section_general' , array(
        'title'      => 'General Settings',
        'description'=> 'This is a Free Version of Vinethemes. You cannot change colors, etc from the Customizer, so please <a href="http://www.vinethemes.com/downloads/devout-personal-wordpress-theme/">Purchase the Theme</a> for all the Premium Features.',
        'priority'   => 90,
    ) );

    // Add Setting

    // General
    $wp_customize->add_setting(
        'ct_favicon'
    );


    $wp_customize->add_setting(
        'ct_responsive'
    );



    $wp_customize->add_setting(
        'home_sidebar',
        array(
            'default'     => false
        )
    );

    $wp_customize->add_setting(
        'ct_sidebar_post',
        array(
            'default'     => false
        )
    );
    $wp_customize->add_setting(
        'archive_sidebar',
        array(
            'default'     => false
        )
    );
    $wp_customize->add_setting(
        'article_post_summary',
        array(
            'default'     => 'full'
        )
    );
    $wp_customize->add_setting(
        'below_slider_area',
        array(
            'default'     => false
        )
    );

    // Header & Logo


    $wp_customize->add_setting(
        'ct_logo'
    );

    $wp_customize->add_setting(
        'ct_header_padding_top',
        array(
            'default'     => '56'
        )
    );
    $wp_customize->add_setting(
        'ct_header_padding_bottom',
        array(
            'default'     => '56'
        )
    );

    // Top Bar
    $wp_customize->add_setting(
        'ct_topbar_social_check',
        array(
            'default'     => false
        )
    );
    $wp_customize->add_setting(
        'ct_topbar_search_check',
        array(
            'default'     => false
        )
    );
    $wp_customize->add_setting(
        'ct_topbar_trending',
        array(
            'default'     => false
        )
    );
    $wp_customize->add_setting(
        'ct_topbar_url',
        array(
            'default'     => ''
        )
    );

// slider area
    $wp_customize->add_setting(
        'vine_themes_slider',
        array(
            'default'     => false
        )
    );
    $wp_customize->add_setting(
        'ct_featured_cat'
    );
    $wp_customize->add_setting(
        'ct_featured_id',
        array(
            'default'     => ''
        )
    );
    $wp_customize->add_setting(
        'ct_featured_slider_slides',
        array(
            'default'     => '5'
        )
    );

    $wp_customize->add_setting(
        'vine_themes_slider_full',
        array(
            'default'     => 'carousel'
        )
    );

    // Featured Boxes
    $wp_customize->add_setting(
        'vine_themes_featured_box',
        array(
            'default'     => false
        )
    );
    $wp_customize->add_setting(
        'ct_promo1_title',
        array(
            'default'     => ''
        )
    );
    $wp_customize->add_setting(
        'ct_promo1_image'
    );
    $wp_customize->add_setting(
        'ct_promo1_url',
        array(
            'default'     => ''
        )
    );
    $wp_customize->add_setting(
        'ct_promo2_title',
        array(
            'default'     => ''
        )
    );
    $wp_customize->add_setting(
        'ct_promo2_image'
    );
    $wp_customize->add_setting(
        'ct_promo2_url',
        array(
            'default'     => ''
        )
    );
    $wp_customize->add_setting(
        'ct_promo3_title',
        array(
            'default'     => ''
        )
    );
    $wp_customize->add_setting(
        'ct_promo3_image'
    );
    $wp_customize->add_setting(
        'ct_promo3_url',
        array(
            'default'     => ''
        )
    );




    // Post Settings
    $wp_customize->add_setting(
        'article_tags',
        array(
            'default'     => false
        )
    );
    $wp_customize->add_setting(
        'article_author',
        array(
            'default'     => false
        )
    );
    $wp_customize->add_setting(
        'article_related_post',
        array(
            'default'     => false
        )
    );
    $wp_customize->add_setting(
        'article_social_share',
        array(
            'default'     => false
        )
    );
    $wp_customize->add_setting(
        'article_author_box',
        array(
            'default'     => false
        )
    );
    $wp_customize->add_setting(
        'article_comment_link',
        array(
            'default'     => false
        )
    );
    $wp_customize->add_setting(
        'article_thumbnail_area',
        array(
            'default'     => false
        )
    );
    $wp_customize->add_setting(
        'article_date_area',
        array(
            'default'     => false
        )
    );
    $wp_customize->add_setting(
        'post_categories',
        array(
            'default'     => false
        )
    );

    $wp_customize->add_setting(
        'post_view_counter',
        array(
            'default'     => false
        )
    );

    // Page
    $wp_customize->add_setting(
        'ct_social_share',
        array(
            'default'     => false
        )
    );

    // Social Media

    $wp_customize->add_setting(
        'ct_facebook',
        array(
            'default'     => ''
        )
    );
    $wp_customize->add_setting(
        'ct_twitter',
        array(
            'default'     => ''
        )
    );
    $wp_customize->add_setting(
        'ct_instagram',
        array(
            'default'     => ''
        )
    );
    $wp_customize->add_setting(
        'ct_pinterest',
        array(
            'default'     => ''
        )
    );
    $wp_customize->add_setting(
        'ct_tumblr',
        array(
            'default'     => ''
        )
    );
    $wp_customize->add_setting(
        'ct_bloglovin',
        array(
            'default'     => ''
        )
    );
    $wp_customize->add_setting(
        'ct_tumblr',
        array(
            'default'     => ''
        )
    );
    $wp_customize->add_setting(
        'ct_google',
        array(
            'default'     => ''
        )
    );
    $wp_customize->add_setting(
        'ct_youtube',
        array(
            'default'     => ''
        )
    );
    $wp_customize->add_setting(
        'ct_dribbble',
        array(
            'default'     => ''
        )
    );
    $wp_customize->add_setting(
        'ct_soundcloud',
        array(
            'default'     => ''
        )
    );
    $wp_customize->add_setting(
        'ct_vimeo',
        array(
            'default'     => ''
        )
    );
    $wp_customize->add_setting(
        'ct_linkedin',
        array(
            'default'     => ''
        )
    );
    $wp_customize->add_setting(
        'ct_rss',
        array(
            'default'     => ''
        )
    );

    // Footer
    $wp_customize->add_setting(
        'ct_footer_copyright',
        array(
            'default'     => '&copy; 2018 - VineThemes. All Rights Reserved. Designed & Developed by <a href="http://www.vinethemes.com">VineThemes.com</a>'
        )
    );
    $wp_customize->add_setting(
        'ct_footer_share',
        array(
            'default'     => false
        )
    );

    // Colors

    // Top bar
    $wp_customize->add_setting(
        'ct_topbar_bg',
        array(
            'default'     => '#fff'
        )
    );

    $wp_customize->add_setting(
        'ct_topbar_nav_color',
        array(
            'default'     => '#fff'
        )
    );
    $wp_customize->add_setting(
        'ct_topbar_nav_color_hover',
        array(
            'default'     => '#999999'
        )
    );

    $wp_customize->add_setting(
        'ct_drop_bg',
        array(
            'default'     => '#000'
        )
    );
    $wp_customize->add_setting(
        'ct_drop_border',
        array(
            'default'     => '#444'
        )
    );
    $wp_customize->add_setting(
        'ct_drop_text_color',
        array(
            'default'     => '#999999'
        )
    );
    $wp_customize->add_setting(
        'ct_drop_text_hover_bg',
        array(
            'default'     => '#fff'
        )
    );
    $wp_customize->add_setting(
        'ct_drop_text_hover_color',
        array(
            'default'     => '#00AFF0'
        )
    );

    $wp_customize->add_setting(
        'ct_topbar_social_color',
        array(
            'default'     => '#000'
        )
    );
    $wp_customize->add_setting(
        'ct_topbar_social_color_hover',
        array(
            'default'     => '#00AFF0'
        )
    );

    $wp_customize->add_setting(
        'ct_topbar_search_magnify',
        array(
            'default'     => '#000'
        )
    );

    // Mobile Menu colors
    $wp_customize->add_setting(
        'ct_mobile_bg',
        array(
            'default'     => '#161616'
        )
    );
    $wp_customize->add_setting(
        'ct_mobile_text',
        array(
            'default'     => '#ffffff'
        )
    );
    $wp_customize->add_setting(
        'ct_mobile_icon',
        array(
            'default'     => '#ffffff'
        )
    );

    // Sidebar
    $wp_customize->add_setting(
        'ct_sidebar_title_bg',
        array(
            'default'     => false
        )
    );
    $wp_customize->add_setting(
        'ct_sidebar_title_text',
        array(
            'default'     => '#fff'
        )
    );
    $wp_customize->add_setting(
        'ct_sidebar_social_icon',
        array(
            'default'     => '#fff'
        )
    );
    $wp_customize->add_setting(
        'ct_sidebar_social_icon_hover',
        array(
            'default'     => '#50aeb5'
        )
    );
    $wp_customize->add_setting(
        'ct_sidebar_newsletter_bg',
        array(
            'default'     => '#f1f1f1'
        )
    );
    $wp_customize->add_setting(
        'ct_sidebar_newsletter_text',
        array(
            'default'     => '#444444'
        )
    );
    $wp_customize->add_setting(
        'ct_sidebar_newsletter_button_bg',
        array(
            'default'     => '#161616'
        )
    );
    $wp_customize->add_setting(
        'ct_sidebar_newsletter_button_text',
        array(
            'default'     => '#ffffff'
        )
    );
    $wp_customize->add_setting(
        'ct_sidebar_newsletter_button_bg_hover',
        array(
            'default'     => '#50aeb5'
        )
    );
    $wp_customize->add_setting(
        'ct_sidebar_newsletter_button_text_hover',
        array(
            'default'     => '#ffffff'
        )
    );

    // Footer
    $wp_customize->add_setting(
        'ct_footer_bg',
        array(
            'default'     => '#111'
        )
    );
    $wp_customize->add_setting(
        'ct_footer_social',
        array(
            'default'     => '#ffffff'
        )
    );
    $wp_customize->add_setting(
        'ct_footer_social_hover',
        array(
            'default'     => '#50aeb5'
        )
    );
    $wp_customize->add_setting(
        'ct_footer_social_line',
        array(
            'default'     => '#313131'
        )
    );
    $wp_customize->add_setting(
        'ct_footer_copyright_color',
        array(
            'default'     => '#888888'
        )
    );
    $wp_customize->add_setting(
        'ct_footer_copyright_link',
        array(
            'default'     => '#333'
        )
    );

    // Posts
    $wp_customize->add_setting(
        'ct_post_title',
        array(
            'default'     => '#000000'
        )
    );
    $wp_customize->add_setting(
        'ct_post_title_divider',
        array(
            'default'     => '#000000'
        )
    );
    $wp_customize->add_setting(
        'ct_post_text',
        array(
            'default'     => '#242424'
        )
    );
    $wp_customize->add_setting(
        'ct_post_h',
        array(
            'default'     => '#242424'
        )
    );
    $wp_customize->add_setting(
        'ct_post_readmore_text',
        array(
            'default'     => '#fff'
        )
    );
    $wp_customize->add_setting(
        'ct_post_readmore_text_hover',
        array(
            'default'     => '#50aeb5'
        )
    );
    $wp_customize->add_setting(
        'ct_post_readmore_line',
        array(
            'default'     => '#50aeb5'
        )
    );
    $wp_customize->add_setting(
        'ct_post_readmore_line_hover',
        array(
            'default'     => '#50aeb5'
        )
    );
    $wp_customize->add_setting(
        'ct_post_share_color',
        array(
            'default'     => '#fff'
        )
    );
    $wp_customize->add_setting(
        'ct_post_share_color_hover',
        array(
            'default'     => '#fff'
        )
    );

    // Main Color
    $wp_customize->add_setting(
        'ct_accent_color',
        array(
            'default'     => '#fff'
        )
    );

    // Custom CSS
    $wp_customize->add_setting(
        'ct_custom_css'
    );


    // Add Control

    // General



    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'upload_favicon',
            array(
                'label'      => 'Upload Favicon',
                'section'    => 'vinethemes_new_section_general',
                'settings'   => 'ct_favicon',
                'priority'	 => 2
            )
        )
    );



    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'responsive',
            array(
                'label'      => 'Disable Responsive',
                'section'    => 'vinethemes_new_section_general',
                'settings'   => 'ct_responsive',
                'type'		 => 'checkbox',
                'priority'	 => 4
            )
        )
    );



    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'sidebar_homepage',
            array(
                'label'      => 'Disable Sidebar on Homepage',
                'section'    => 'vinethemes_new_section_general',
                'settings'   => 'home_sidebar',
                'type'		 => 'checkbox',
                'priority'	 => 5
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'sidebar_post',
            array(
                'label'      => 'Disable Sidebar on Posts',
                'section'    => 'vinethemes_new_section_general',
                'settings'   => 'ct_sidebar_post',
                'type'		 => 'checkbox',
                'priority'	 => 6
            )
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'sidebar_archive',
            array(
                'label'      => 'Disable Sidebar on Archives',
                'section'    => 'vinethemes_new_section_general',
                'settings'   => 'archive_sidebar',
                'type'		 => 'checkbox',
                'priority'	 => 7
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'post_summary',
            array(
                'label'          => 'Homepage/Archive Post Summary Type',
                'section'        => 'vinethemes_new_section_general',
                'settings'       => 'article_post_summary',
                'type'           => 'radio',
                'priority'	 => 8,
                'choices'        => array(
                    'full'   => 'Use Full Post',
                    'excerpt'  => 'Use Excerpt',
                )
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'below_slider_area_setting',
            array(
                'label'      => 'Enable Below Slider Area (Use Widget Section to add something in the below slider area)',
                'section'    => 'vinethemes_new_section_general',
                'settings'   => 'below_slider_area',
                'type'		 => 'checkbox',
                'priority'	 => 9
            )
        )
    );

    // Header and Logo




    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'upload_logo',
            array(
                'label'      => 'Upload Logo',
                'section'    => 'vinethemes_new_section_logo_header',
                'settings'   => 'ct_logo',
                'priority'	 => 20
            )
        )
    );

    $wp_customize->add_control(
        new Customize_Number_Control(
            $wp_customize,
            'header_padding_top',
            array(
                'label'      => 'Top Header Padding',
                'section'    => 'vinethemes_new_section_logo_header',
                'settings'   => 'ct_header_padding_top',
                'type'		 => 'number',
                'priority'	 => 22
            )
        )
    );
    $wp_customize->add_control(
        new Customize_Number_Control(
            $wp_customize,
            'header_padding_bottom',
            array(
                'label'      => 'Bottom Header Padding',
                'section'    => 'vinethemes_new_section_logo_header',
                'settings'   => 'ct_header_padding_bottom',
                'type'		 => 'number',
                'priority'	 => 23
            )
        )
    );

    // Top Bar

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'topbar_search_check',
            array(
                'label'      => 'Disable Top Bar Search',
                'section'    => 'vinethemes_new_section_topbar',
                'settings'   => 'ct_topbar_search_check',
                'type'		 => 'checkbox',
                'priority'	 => 4
            )
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'topbar_trending',
            array(
                'label'      => 'Disable Top Right Trending Icon',
                'section'    => 'vinethemes_new_section_topbar',
                'settings'   => 'ct_topbar_trending',
                'type'		 => 'checkbox',
                'priority'	 => 5
            )
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'trending_url',
            array(
                'label'      => 'Top Right Trending Icon Category URL',
                'section'    => 'vinethemes_new_section_topbar',
                'settings'   => 'ct_topbar_url',
                'type'		 => 'text',
                'priority'	 => 6
            )
        )
    );


    // Featured Boxes area
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'featured_boxes',
            array(
                'label'      => 'Enable Featured Boxes',
                'section'    => 'vinethemes_new_section_featured_boxes',
                'settings'   => 'vine_themes_featured_box',
                'type'		 => 'checkbox',
                'priority'	 => 1
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'promo1_title',
            array(
                'label'      => 'Featured Box1 Title',
                'section'    => 'vinethemes_new_section_featured_boxes',
                'settings'   => 'ct_promo1_title',
                'type'		 => 'text',
                'priority'	 => 3
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'promo1_image',
            array(
                'label'      => 'Featured Box1 Image',
                'section'    => 'vinethemes_new_section_featured_boxes',
                'settings'   => 'ct_promo1_image',
                'priority'	 => 4
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'promo1_url',
            array(
                'label'      => 'Featured Box1 URL',
                'section'    => 'vinethemes_new_section_featured_boxes',
                'settings'   => 'ct_promo1_url',
                'type'		 => 'text',
                'priority'	 => 5
            )
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'promo2_title',
            array(
                'label'      => 'Featured Box2 Title',
                'section'    => 'vinethemes_new_section_featured_boxes',
                'settings'   => 'ct_promo2_title',
                'type'		 => 'text',
                'priority'	 => 6
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'promo2_image',
            array(
                'label'      => 'Featured Box2 Image',
                'section'    => 'vinethemes_new_section_featured_boxes',
                'settings'   => 'ct_promo2_image',
                'priority'	 => 7
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'promo2_url',
            array(
                'label'      => 'Featured Box2 URL',
                'section'    => 'vinethemes_new_section_featured_boxes',
                'settings'   => 'ct_promo2_url',
                'type'		 => 'text',
                'priority'	 => 8
            )
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'promo3_title',
            array(
                'label'      => 'Featured Box3 Title',
                'section'    => 'vinethemes_new_section_featured_boxes',
                'settings'   => 'ct_promo3_title',
                'type'		 => 'text',
                'priority'	 => 9
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'promo3_image',
            array(
                'label'      => 'Featured Box3 Image',
                'section'    => 'vinethemes_new_section_featured_boxes',
                'settings'   => 'ct_promo3_image',
                'priority'	 => 10
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'promo3_url',
            array(
                'label'      => 'Featured Box3 URL',
                'section'    => 'vinethemes_new_section_featured_boxes',
                'settings'   => 'ct_promo3_url',
                'type'		 => 'text',
                'priority'	 => 11
            )
        )
    );




// slider area
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'featured_slider',
            array(
                'label'      => 'Enable Slider',
                'section'    => 'vinethemes_new_section_featured',
                'settings'   => 'vine_themes_slider',
                'type'		 => 'checkbox',
                'priority'	 => 2
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Category_Control(
            $wp_customize,
            'featured_cat',
            array(
                'label'    => 'Select slider Category',
                'settings' => 'ct_featured_cat',
                'section'  => 'vinethemes_new_section_featured',
                'priority'	 => 3
            )
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'featured_id',
            array(
                'label'      => 'Select slider post/page IDs',
                'section'    => 'vinethemes_new_section_featured',
                'settings'   => 'ct_featured_id',
                'type'		 => 'text',
                'priority'	 => 4
            )
        )
    );

    $wp_customize->add_control(
        new Customize_Number_Control(
            $wp_customize,
            'featured_slider_slides',
            array(
                'label'      => 'Amount of Slides',
                'section'    => 'vinethemes_new_section_featured',
                'settings'   => 'ct_featured_slider_slides',
                'type'		 => 'number',
                'priority'	 => 5
            )
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'featured_slider_full',
            array(
                'label'      => 'Select Slider Styles',
                'section'    => 'vinethemes_new_section_featured',
                'settings'   => 'vine_themes_slider_full',
                'type'		 => 'radio',
                'priority'	 => 6,
                'choices'        => array(
                    'full'   => 'Full Width Slider'
                )
            )
        )
    );

    // Post Settings
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'post_thumb',
            array(
                'label'      => 'Hide slider Image from top of Post',
                'section'    => 'vinethemes_new_section_post',
                'settings'   => 'article_thumbnail_area',
                'type'		 => 'checkbox',
                'priority'	 => 1
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'post_cat',
            array(
                'label'      => 'Hide Category',
                'section'    => 'vinethemes_new_section_post',
                'settings'   => 'post_categories',
                'type'		 => 'checkbox',
                'priority'	 => 2
            )
        )
    );



    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'post_date',
            array(
                'label'      => 'Hide Date',
                'section'    => 'vinethemes_new_section_post',
                'settings'   => 'article_date_area',
                'type'		 => 'checkbox',
                'priority'	 => 3
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'post_tags',
            array(
                'label'      => 'Hide Tags',
                'section'    => 'vinethemes_new_section_post',
                'settings'   => 'article_tags',
                'type'		 => 'checkbox',
                'priority'	 => 4
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'post_share',
            array(
                'label'      => 'Hide Share Buttons',
                'section'    => 'vinethemes_new_section_post',
                'settings'   => 'article_social_share',
                'type'		 => 'checkbox',
                'priority'	 => 5
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'post_share_author',
            array(
                'label'      => 'Hide Author Name',
                'section'    => 'vinethemes_new_section_post',
                'settings'   => 'article_author_box',
                'type'		 => 'checkbox',
                'priority'	 => 6
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'post_comment_link',
            array(
                'label'      => 'Hide Comment Link',
                'section'    => 'vinethemes_new_section_post',
                'settings'   => 'article_comment_link',
                'type'		 => 'checkbox',
                'priority'	 => 7
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'post_author',
            array(
                'label'      => 'Hide Author Box',
                'section'    => 'vinethemes_new_section_post',
                'settings'   => 'article_author',
                'type'		 => 'checkbox',
                'priority'	 => 8
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'post_related',
            array(
                'label'      => 'Hide Related Posts Box',
                'section'    => 'vinethemes_new_section_post',
                'settings'   => 'article_related_post',
                'type'		 => 'checkbox',
                'priority'	 => 9
            )
        )
    );

    // Page
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'page_share',
            array(
                'label'      => 'Hide Share Buttons',
                'section'    => 'vinethemes_new_section_page',
                'settings'   => 'ct_social_share',
                'type'		 => 'checkbox',
                'priority'	 => 1
            )
        )
    );

    // Social Media
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'facebook',
            array(
                'label'      => 'Facebook',
                'section'    => 'vinethemes_new_section_social',
                'settings'   => 'ct_facebook',
                'type'		 => 'text',
                'priority'	 => 1
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'twitter',
            array(
                'label'      => 'Twitter',
                'section'    => 'vinethemes_new_section_social',
                'settings'   => 'ct_twitter',
                'type'		 => 'text',
                'priority'	 => 2
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'instagram',
            array(
                'label'      => 'Instagram',
                'section'    => 'vinethemes_new_section_social',
                'settings'   => 'ct_instagram',
                'type'		 => 'text',
                'priority'	 => 3
            )
        )
    );



    // Footer

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'footer_share',
            array(
                'label'      => 'Hide Footer Share Links',
                'section'    => 'vinethemes_new_section_footer',
                'settings'   => 'ct_footer_share',
                'type'		 => 'checkbox',
                'priority'	 => 2
            )
        )
    );

    // Colors

    // Top bar Colors
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'topbar_bg',
            array(
                'label'      => 'Top Bar BG',
                'section'    => 'vinethemes_new_section_color_topbar',
                'settings'   => 'ct_topbar_bg',
                'priority'	 => 1
            )
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'topbar_nav_color',
            array(
                'label'      => 'Top Bar Menu Text Color',
                'section'    => 'vinethemes_new_section_color_topbar',
                'settings'   => 'ct_topbar_nav_color',
                'priority'	 => 2
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'topbar_nav_color_hover',
            array(
                'label'      => 'Top Bar Menu Text Hover Color',
                'section'    => 'vinethemes_new_section_color_topbar',
                'settings'   => 'ct_topbar_nav_color_hover',
                'priority'	 => 3
            )
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'drop_bg',
            array(
                'label'      => 'Dropdown BG',
                'section'    => 'vinethemes_new_section_color_topbar',
                'settings'   => 'ct_drop_bg',
                'priority'	 => 4
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'drop_border',
            array(
                'label'      => 'Dropdown Border Color',
                'section'    => 'vinethemes_new_section_color_topbar',
                'settings'   => 'ct_drop_border',
                'priority'	 => 5
            )
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'drop_text_color',
            array(
                'label'      => 'Dropdown Text Color',
                'section'    => 'vinethemes_new_section_color_topbar',
                'settings'   => 'ct_drop_text_color',
                'priority'	 => 6
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'drop_text_hover_bg',
            array(
                'label'      => 'Dropdown Text Hover BG',
                'section'    => 'vinethemes_new_section_color_topbar',
                'settings'   => 'ct_drop_text_hover_bg',
                'priority'	 => 7
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'drop_text_hover_color',
            array(
                'label'      => 'Dropdown Text Hover Color',
                'section'    => 'vinethemes_new_section_color_topbar',
                'settings'   => 'ct_drop_text_hover_color',
                'priority'	 => 8
            )
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'topbar_social_color',
            array(
                'label'      => 'Top Bar Social Icons',
                'section'    => 'vinethemes_new_section_color_topbar',
                'settings'   => 'ct_topbar_social_color',
                'priority'	 => 9
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'topbar_social_color_hover',
            array(
                'label'      => 'Top Bar Social Icons Hover',
                'section'    => 'vinethemes_new_section_color_topbar',
                'settings'   => 'ct_topbar_social_color_hover',
                'priority'	 => 11
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'topbar_search_magnify',
            array(
                'label'      => 'Top Bar Search Magnify Color',
                'section'    => 'vinethemes_new_section_color_topbar',
                'settings'   => 'ct_topbar_search_magnify',
                'priority'	 => 13
            )
        )
    );

    // Mobile menu
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'mobile_bg',
            array(
                'label'      => 'Mobile Menu BG Color',
                'section'    => 'vinethemes_new_section_mobile',
                'settings'   => 'ct_mobile_bg',
                'priority'	 => 1
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'mobile_text',
            array(
                'label'      => 'Mobile Menu Link Color',
                'section'    => 'vinethemes_new_section_mobile',
                'settings'   => 'ct_mobile_text',
                'priority'	 => 2
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'mobile_icon',
            array(
                'label'      => 'Mobile Menu Toggle Icon Color',
                'section'    => 'vinethemes_new_section_mobile',
                'settings'   => 'ct_mobile_icon',
                'priority'	 => 3
            )
        )
    );

    // Sidebar
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'sidebar_title_bg',
            array(
                'label'      => 'Sidebar Widget Title BG',
                'section'    => 'vinethemes_new_section_color_sidebar',
                'settings'   => 'ct_sidebar_title_bg',
                'priority'	 => 1
            )
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'sidebar_title_text',
            array(
                'label'      => 'Sidebar Widget Title Text Color',
                'section'    => 'vinethemes_new_section_color_sidebar',
                'settings'   => 'ct_sidebar_title_text',
                'priority'	 => 3
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'sidebar_social_icon',
            array(
                'label'      => 'Sidebar Social Icon Color',
                'section'    => 'vinethemes_new_section_color_sidebar',
                'settings'   => 'ct_sidebar_social_icon',
                'priority'	 => 4
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'sidebar_social_icon_hover',
            array(
                'label'      => 'Sidebar Social Icon Hover Color',
                'section'    => 'vinethemes_new_section_color_sidebar',
                'settings'   => 'ct_sidebar_social_icon_hover',
                'priority'	 => 5
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'sidebar_newsletter_bg',
            array(
                'label'      => 'Mailchimp Widget BG Color',
                'section'    => 'vinethemes_new_section_color_sidebar',
                'settings'   => 'ct_sidebar_newsletter_bg',
                'priority'	 => 6
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'sidebar_newsletter_text',
            array(
                'label'      => 'Mailchimp Widget Text Color',
                'section'    => 'vinethemes_new_section_color_sidebar',
                'settings'   => 'ct_sidebar_newsletter_text',
                'priority'	 => 7
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'sidebar_newsletter_button_bg',
            array(
                'label'      => 'Mailchimp Widget Button BG Color',
                'section'    => 'vinethemes_new_section_color_sidebar',
                'settings'   => 'ct_sidebar_newsletter_button_bg',
                'priority'	 => 8
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'sidebar_newsletter_button_text',
            array(
                'label'      => 'Mailchimp Widget Button Text Color',
                'section'    => 'vinethemes_new_section_color_sidebar',
                'settings'   => 'ct_sidebar_newsletter_button_text',
                'priority'	 => 9
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'sidebar_newsletter_button_bg_hover',
            array(
                'label'      => 'Mailchimp Widget Button BG Hover Color',
                'section'    => 'vinethemes_new_section_color_sidebar',
                'settings'   => 'ct_sidebar_newsletter_button_bg_hover',
                'priority'	 => 10
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'sidebar_newsletter_button_text_hover',
            array(
                'label'      => 'Mailchimp Widget Button Text Hover Color',
                'section'    => 'vinethemes_new_section_color_sidebar',
                'settings'   => 'ct_sidebar_newsletter_button_text_hover',
                'priority'	 => 11
            )
        )
    );

    // Footer
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_bg',
            array(
                'label'      => 'Footer BG Color',
                'section'    => 'vinethemes_new_section_color_footer',
                'settings'   => 'ct_footer_bg',
                'priority'	 => 1
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_social',
            array(
                'label'      => 'Footer Social Icon Color',
                'section'    => 'vinethemes_new_section_color_footer',
                'settings'   => 'ct_footer_social',
                'priority'	 => 2
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_social_hover',
            array(
                'label'      => 'Footer Social Icon Hover Color',
                'section'    => 'vinethemes_new_section_color_footer',
                'settings'   => 'ct_footer_social_hover',
                'priority'	 => 3
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_social_line',
            array(
                'label'      => 'Footer Social Separator Line',
                'section'    => 'vinethemes_new_section_color_footer',
                'settings'   => 'ct_footer_social_line',
                'priority'	 => 4
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_copyright_color',
            array(
                'label'      => 'Footer Copyright Text Color',
                'section'    => 'vinethemes_new_section_color_footer',
                'settings'   => 'ct_footer_copyright_color',
                'priority'	 => 5
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_copyright_link',
            array(
                'label'      => 'Footer Copyright Link Color',
                'section'    => 'vinethemes_new_section_color_footer',
                'settings'   => 'ct_footer_copyright_link',
                'priority'	 => 6
            )
        )
    );

    // Posts
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'post_title',
            array(
                'label'      => 'Post Title Color',
                'section'    => 'vinethemes_new_section_color_post_color',
                'settings'   => 'ct_post_title',
                'priority'	 => 1
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'post_title_divider',
            array(
                'label'      => 'Post Title Divider Color',
                'section'    => 'vinethemes_new_section_color_post_color',
                'settings'   => 'ct_post_title_divider',
                'priority'	 => 2
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'post_text',
            array(
                'label'      => 'Post Text Color',
                'section'    => 'vinethemes_new_section_color_post_color',
                'settings'   => 'ct_post_text',
                'priority'	 => 2
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'post_h',
            array(
                'label'      => 'Post H1-H6 Color',
                'section'    => 'vinethemes_new_section_color_post_color',
                'settings'   => 'ct_post_h',
                'priority'	 => 3
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'post_readmore_text',
            array(
                'label'      => 'Read More Text Color',
                'section'    => 'vinethemes_new_section_color_post_color',
                'settings'   => 'ct_post_readmore_text',
                'priority'	 => 4
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'post_readmore_text_hover',
            array(
                'label'      => 'Read More Text Hover Color',
                'section'    => 'vinethemes_new_section_color_post_color',
                'settings'   => 'ct_post_readmore_text_hover',
                'priority'	 => 6
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'post_readmore_line',
            array(
                'label'      => 'Read More Underline Color',
                'section'    => 'vinethemes_new_section_color_post_color',
                'settings'   => 'ct_post_readmore_line',
                'priority'	 => 6
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'post_readmore_line_hover',
            array(
                'label'      => 'Read More Underline Hover Color',
                'section'    => 'vinethemes_new_section_color_post_color',
                'settings'   => 'ct_post_readmore_line_hover',
                'priority'	 => 6
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'post_share_color',
            array(
                'label'      => 'Post Share Link Color',
                'section'    => 'vinethemes_new_section_color_post_color',
                'settings'   => 'ct_post_share_color',
                'priority'	 => 8
            )
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'post_share_color_hover',
            array(
                'label'      => 'Post Share Link Hover Color',
                'section'    => 'vinethemes_new_section_color_post_color',
                'settings'   => 'ct_post_share_color_hover',
                'priority'	 => 9
            )
        )
    );

    // Main Color
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'accent_color',
            array(
                'label'      => 'Main Color Color',
                'section'    => 'vinethemes_new_section_color_accent',
                'settings'   => 'ct_accent_color',
                'priority'	 => 1
            )
        )
    );

    // Custom CSS
    $wp_customize->add_control(
        new Customize_CustomCss_Control(
            $wp_customize,
            'custom_css',
            array(
                'label'      => 'Custom CSS',
                'section'    => 'vinethemes_new_section_custom_css',
                'settings'   => 'ct_custom_css',
                'type'		 => 'custom_css',
                'priority'	 => 1
            )
        )
    );


    // Remove Sections
    $wp_customize->remove_section( 'title_tagline');
    $wp_customize->remove_section( 'nav');
    $wp_customize->remove_section( 'static_front_page');
    $wp_customize->remove_section( 'colors');



}
add_action( 'customize_register', 'vinethemes_register_theme_customizer' );
?>